#! /bin/sh
PRODUCET=renderbus
DESKTOPFILE="$PRODUCET.desktop"
APP_DIR=`pwd`
DESKTOP_DIR=`xdg-user-dir "DESKTOP"`
EXEC="sh $APP_DIR/$PRODUCET.sh"
ICON="$APP_DIR/resource/$PRODUCET.ico"
FILENAME="$APP_DIR/$DESKTOPFILE"
DESTPATH="$DESKTOP_DIR/$DESKTOPFILE"
MENUPATH="${HOME}/.local/share/applications/$DESKTOPFILE"

function WriteINIfile()
{
    echo -e "[Desktop Entry]" > "$FILENAME"
    echo -e "Type=Application" >> "$FILENAME"
    echo -e "Path=$APP_DIR" >> "$FILENAME"
    echo -e "Exec=$EXEC" >> "$FILENAME"
    echo -e "Name=RenderBus Desktop" >> "$FILENAME"
    echo -e "GenericName=A client for renderfarm" >> "$FILENAME"
    echo -e "Icon=$ICON" >> "$FILENAME"
    echo -e "StartupWMClass=RenderBus Desktop" >> "$FILENAME"
    echo -e "Terminal=false" >> "$FILENAME"
    echo -e "Categories=Application;Graphics;" >> "$FILENAME"
    echo -e "MimeType=text/x-mayasrc;text/x-houdinisrc;" >> "$FILENAME"
}

if [ "$1" != "" ] ;then
   WriteINIfile $PRODUCET
   #copy file to ~/desktop
   cp $FILENAME $DESTPATH
   #gio set $DESTPATH "metadata::trusted" yes
   #copy file to ~/.local/share/applications
   cp $FILENAME $MENUPATH
   chmod +x $DESTPATH
   chmod +x $MENUPATH
fi
