# Generated by Django 2.2.7 on 2019-12-06 07:26

import common.fields.model
from django.db import migrations, models


def create_internal_platform(apps, schema_editor):
    model = apps.get_model("assets", "Platform")
    db_alias = schema_editor.connection.alias
    type_platforms = (
        ('Linux', 'Linux', None),
        ('Unix', 'Unix', None),
        ('MacOS', 'MacOS', None),
        ('BSD', 'BSD', None),
        ('Windows', 'Windows', None),
        ('Windows2016', 'Windows', {'security': 'tls'}),
        ('Other', 'Other', None),
    )
    for name, base, meta in type_platforms:
        model.objects.using(db_alias).create(
            name=name, base=base, internal=True, meta=meta
        )


class Migration(migrations.Migration):

    dependencies = [
        ('assets', '0043_auto_20191114_1111'),
    ]

    operations = [
        migrations.CreateModel(
            name='Platform',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.SlugField(allow_unicode=True, unique=True, verbose_name='Name')),
                ('base', models.CharField(choices=[('Linux', 'Linux'), ('Unix', 'Unix'), ('MacOS', 'MacOS'), ('BSD', 'BSD'), ('Windows', 'Windows'), ('Other', 'Other')], default='Linux', max_length=16, verbose_name='Base')),
                ('charset', models.CharField(choices=[('utf8', 'UTF-8'), ('gbk', 'GBK')], default='utf8', max_length=8, verbose_name='Charset')),
                ('meta', common.fields.model.JsonDictTextField(blank=True, null=True, verbose_name='Meta')),
                ('internal', models.BooleanField(default=False, verbose_name='Internal')),
                ('comment', models.TextField(blank=True, null=True, verbose_name='Comment')),
            ],
            options={
                'verbose_name': 'Platform'
            }
        ),
        migrations.RunPython(create_internal_platform)
    ]
