# Generated by Django 2.2.10 on 2020-07-21 09:39

from django.db import migrations, models

from django.db.models import F
from ..models.asset_permission import Action


def migrate_asset_permission(apps, schema_editor):
    # 已有的资产权限默认拥有剪切板复制粘贴动作
    AssetPermission = apps.get_model('perms', 'AssetPermission')
    AssetPermission.objects.all().update(actions=F('actions').bitor(Action.CLIPBOARD_COPY_PASTE))


class Migration(migrations.Migration):

    dependencies = [
        ('perms', '0010_auto_20191218_1705'),
    ]

    operations = [
        migrations.AlterField(
            model_name='assetpermission',
            name='actions',
            field=models.IntegerField(choices=[(255, 'All'), (1, 'Connect'), (2, 'Upload file'), (4, 'Download file'), (6, 'Upload download'), (8, 'Clipboard copy'), (16, 'Clipboard paste'), (24, 'Clipboard copy paste')], default=255, verbose_name='Actions'),
        ),
        migrations.RunPython(migrate_asset_permission)
    ]
