/*
 * Copyright 2024 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package io.netty.channel.uring;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

public class UserDataTest {
    @Test
    public void testUserData() {
        // Ensure userdata works with negative and positive values
        for (int fd : new int[] { -10, -1, 0, 1, 10, Short.MAX_VALUE, Integer.MAX_VALUE }) {
            for (byte op = 0; op < 20; op++) {
                for (int data = Short.MIN_VALUE; data <= Short.MAX_VALUE; data++) {
                    final short expectedData = (short) data;
                    long udata = UserData.encode(fd, op, expectedData);
                    assertEquals(fd, UserData.decodeId(udata));
                    assertEquals(op, UserData.decodeOp(udata));
                    assertEquals(expectedData, UserData.decodeData(udata));
                }
            }
        }
    }
}
